function [T2] = atest(r,rboots,sboots,gboots,K1) 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% MATLAB code: Exercise 7.7(b)
% File: atest.m
%
% Converted from GAUSS code written by Leena Kalliovirta 
% Autocorrelation test statistic based on UNIVARIATE quantile  
% residuals (QRs).  
%               
% INPUT:     
% r      = vector of quantile residuals (T * 1).        
% rboots = simulated vector of QRs using estimated model (Tboots * 1).        
% sboots = simulated matrix of scores of QRs using estimated model 
%          (Tboots * k) with k the number of columns of sboots.                                
% gboots = simulated matrix of derivatives of QRs using estimated 
%          models (Tboots * k).                                    
% K1     = number of lags used in the autocorrelation test. 
%            
% OUTPUT: 
% T2     = scalar value of the test statistic, follows a Chi^{2}(K1) 
%          distribution under H0: no autocorrelation in QRs.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
T       = length(r);
Tboots  = length(rboots);
[~,k]   = size(sboots);

warning('off','all')  % Disable all warnings. 
%          Replace 'off' by 'on' to enable
% Warning: Matrix "cov" may be close to singular or badly scaled.
%          Results may be inaccurate. 

cov     = inv((sboots'*sboots)/Tboots);
G2      = zeros(K1,k); 
RR      = zeros(K1,1); 
guboots = zeros(Tboots-K1,K1); 

for t1=1:(Tboots-K1);
  help = ((rboots(t1+K1))*rboots(t1+K1-1));
  for i=2:K1
    help = [help;((rboots(t1+K1))*rboots(t1+K1-i))];
  end
  guboots(t1,:) = help;
end

Sigma2 = (horzcat(sboots(K1+1:Tboots,:),guboots))'...
         *(horzcat(sboots(K1+1:Tboots,:),guboots))/(Tboots-K1);

for i1=1:K1
  for j=1:k             
    G2(i1,j) = (mean(rboots(1+i1:Tboots).*gboots(1:Tboots-i1,j)+...
               rboots(1:Tboots-i1).*gboots(1+i1:Tboots,j)))';        
    RR(i1)   = mean(r(1+i1:T).*r(1:T-i1));                                       
  end
end

O2 = [G2*cov,eye(K1)]*Sigma2*[G2*cov,eye(K1)]';
T2 = (T-K1)*(RR')*inv(O2)*RR;   % Autocorrelation test statistic